import { app, BrowserWindow, ipcMain, dialog } from "electron";
import path from "path";
import { fileURLToPath } from "url";

const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);

const createWindow = () => {
  const IS_DEV = !app.isPackaged;

  const mainWindow = new BrowserWindow({
    // width: 1080,
    // height: 1080,
    width: 1136,
    height: 1136,
    title: "IMG2WEBP",
    webPreferences: {
      nodeIntegration: false, // node.jsの機能を使えるようにする
      contextIsolation: true, // メインプロセスとレンダラープロセスのjsを分離する
      preload: path.join(__dirname, "preload.cjs"),
    },
  });

  if (IS_DEV) {
    // 起動時にデベロッパーツールを開く
    mainWindow.webContents.openDevTools({ mode: "detach" });
  }

  // mainWindow.loadFile(path.join(__dirname, "../dist/index.html"));
  mainWindow.loadFile(path.join(__dirname, "./dist/index.html"));
};

// renderer からの invoke("open-dialog") を受け取る
// ipcMain.handle("open-dialog", async () => {
//   const { canceled, filePaths } = await dialog.showOpenDialog({
//     properties: ["openFile"],
//   });
//   if (canceled || filePaths.length === 0) return "キャンセルされました";
//   return filePaths[0];
// });

app.once("ready", createWindow);

app.once("window-all-closed", () => app.quit());
